﻿/****************************************************/
/* Opciones presenta                                */
/* En general,  explicado en Cuadro 3. Punto 1.2)   */
/* Lo indicado, explicado en Cuadro 1. Punto 3.1)   */
/****************************************************/

using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class OpcionesPresenta : MonoBehaviour
{
    bool aparece, haySonido;

    float maxY, incY;
    float posY;

    public int velocidad = 30; // Para variar la velocidad a la que aparece el cubo

    public AudioClip pickSound;   //  Variable en la que meter el nombre del fichero de sonido
                                  //  Como es public, aparece un campo editable en la ventana de Inspector  
                                  //  También se podía poner [SerializeField] y definirla como private
    float elPitch;


    // Start is called before the first frame update
    void Start()
    {
        /*****   Ocultar opciones (Explicado en el Cuadro 1. Punto 3.1)   ****/

        gameObject.transform.position += Vector3.down * 1.1f;   //  Bajamos el cubo por debajo de la superficie. 
                                                                // El cubo mide 1 de altura y su centro está en el 0,5. 
                                                                // Lo bajamos un poco más (0,1) para que no se vea nada

        /*********************************************************************/

        aparece = haySonido = false;

        maxY = 0.4f; //  Altura máxima a la que sube el cubo (0.5 para que esté sobre el suelo)
        incY = Random.Range(0.01f, 0.05f);  //  Calculamos un incremento aleatorio (para dar varias velocidades)

        elPitch = Random.Range(0.5f, 3f);  //  Calculamos un pitch aleatorio (para dar varios tonos)
    }


    // Update is called once per frame
    void Update()
    {
        if (aparece)
        {
            posY = gameObject.transform.position.y;  //  Leemos la posición y del cubo

            if (posY <= maxY)  // No podemos pasarnos de la altura máxima, maxY
            {
                gameObject.transform.position += Vector3.up * incY * velocidad * Time.deltaTime;  //  Subimos el cubo el intervalo incY, ajustado a la velocidad
            }
            else //  cuando ya se ha alcanzado o superado la altura máxima
            {
                aparece = false;  //  Desactiva la elevación de los cubos de las opciones
                gameObject.GetComponent<AudioSource>().Stop();  //  Apagamos el sonido 
            }

            if (! haySonido)
            {
                //  Emitimos sonido mientras sube
                gameObject.GetComponent<AudioSource>().clip = pickSound;    //  Leemos el fichero indicado en el componente
                gameObject.GetComponent<AudioSource>().volume = 1.0f;       //  Fijamos el volumen (de 0 a 1)
                gameObject.GetComponent<AudioSource>().loop = true;         //  Activamos loop, por si sube muy despacio
                gameObject.GetComponent<AudioSource>().pitch = elPitch;     //  Cambiamos timbre (de 0 a 1)
                gameObject.GetComponent<AudioSource>().Play();              //  Activamos sonido

                haySonido = true; //  Para no empezar el audio cada frame
            }
        }

    }

    //  Función pública para acceer desde otros scripts (PremioCaptura.cs)
    //  Activa el proceso de aparición de los cubos de opciones
    public void Presenta ()
    {
        aparece = true;
    }
}
