﻿/********************************************************/
/* Premios Captura                                      */
/* En general,  explicado en Cuadro 2. Punto 1.1 a 1.3) */
/* Lo indicado, explicado en Cuadro 1. Punto 3.1)       */
/********************************************************/


using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PremiosCaptura : MonoBehaviour
{
    public AudioClip pickSound;  // Audio CLip en el que guardamos el sonido a emitir cuando se captura premio

    int iMarcador;  //  Variable para el marcador
    string msgMarcador;  //  Cadena en la que ir completando el mensaje que aparecerá en el marcador

    float tiempo, tiempoAnt;
    int minutos, segundos;

    public GameObject controlIni, controlFin;  //  Variables con los dos controladores, para activar/desactivarlos de forma más cómoda

    GameObject[] matrizPremios;  //  Matriz para ocultar los premios que quedan por capturar. Ver Cuadro 3: 1.3 Tratar conjuntos de Game Objects

    // Start is called before the first frame update
    void Start()
    {
        iMarcador = 0;    //  Inicializamos marcador a cero
        tiempo = tiempoAnt = 0;
    }

    // Update is called once per frame
    void Update()
    {
        tiempo += Time.deltaTime;  //  Acumulamos tiempo transcurrido desde el último frame

        if (tiempo > tiempoAnt + 1)  // Para presentar el tiempo cada segundo. Si no, es continuo
        {
            minutos = (int)tiempo / 60;  // Solo la parte entera de la división
            segundos = (int)tiempo % 60;  // Solo el resto de la división

            Debug.Log("Tiempo: " + minutos + ":" + segundos);  // Indicamos tiempo (luego lo presentaremos por la interfaz de usuario)

            tiempoAnt = tiempo;  // Guardamos para ver intervalo de tiempo transcurrido
        }

    } 


    private void OnControllerColliderHit(ControllerColliderHit loColisionado)
    {
        string etiqueta = loColisionado.collider.gameObject.tag;  // Guardamos en 'etiqueta' el tag del objeto que ha colisionado

        if (etiqueta == "Premio")  //  Actuación en caso de colisión con un Premio
        {
            Debug.Log("colisión con " + etiqueta); //  Aviso para debug. Se puede desactivar

            /***  Eliminamos premio de la escena (Explicado en Cuadro 2. Punto 1.1)  ***/

            Destroy(loColisionado.collider.gameObject);

            /***************************************************************************/

            /***  Emitimos sonido al capturar premio (Explicado en Cuadro 2. Punto 1.2)  ***/

            gameObject.GetComponent<AudioSource>().clip = pickSound;    //  Leemos el fichero indicado en el componente
            gameObject.GetComponent<AudioSource>().volume = 1.0f;       //  Fijamos el volumen (de 0 a 1)
            gameObject.GetComponent<AudioSource>().loop = false;        //  Desactivamos el loop, por si acaso
            gameObject.GetComponent<AudioSource>().Play();              //  Activamos el sonido

            /*******************************************************************************/


            /***  Actualizamos marcador  (Explicado en Cuadro 2. Punto 1.3) ***/

            iMarcador ++;              // Incrementamos iMarcador. Tabién se puede poner iMarcador++;
            msgMarcador = "Marcador: " + iMarcador; // Generamos mensaje a presentar en el marcador de la interfaz

            if (iMarcador >= 8) msgMarcador = "¡Salta sobre tu nivel!"; //  En el cuadro 3, cuando se capturan los 8 premios, se cambia el mensaje del marcador

            Debug.LogWarning(msgMarcador);


            /*******************************************************************/


            /*** Respuesta al estado del marcador (Explicado en Cuadro 3. Punto 1.1) ***/

            if (iMarcador >= 8)
            {

                /***  Eliminamos premios que puedan quedar por capturar (Explicado en Cuadro 3. Punto 1.2)  ***/

                GameObject[] matrizPremios = GameObject.FindGameObjectsWithTag("Premio");
                foreach (GameObject unPremio in matrizPremios) Destroy(unPremio);
                
                /**********************************************************************************************/

                
                GameObject.Find("Banda Sonora").GetComponent<BandaSonoraConmuta>().ActivaSonido(false);  //  Apagamos la banda sonora

                controlIni.SetActive(false); //  Desactivamos el controlador en primera persona
                controlFin.SetActive(true); //  Activamos el controlador en tercera persona y la cámara (agrupados en un GameObject)


                /***  Llamamos a la función de "presentar opciones"   ***/
                GameObject.Find("Opcion 1").GetComponent<OpcionesPresenta>().Presenta();
                GameObject.Find("Opcion 2").GetComponent<OpcionesPresenta>().Presenta();
                GameObject.Find("Opcion 3").GetComponent<OpcionesPresenta>().Presenta();


            }


        }
        
    }
}
