/************************************************/
/* Premios Gira                                 */
/* Explicado en Cuadro 1. Punto 2.3)            */
/************************************************/
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PremiosGira : MonoBehaviour
{
    private float posX, posY, posZ;
    private float giroX, giroY, giroZ;

    public int VelGiro = 10; // Factor de multiplicación para regular velocidad
	                         // Lo hacemos público para poder cambiarlo interactivamente


    // Start is called before the first frame update
    void Start()
    {
        //  Defino los desplazamientos aleatorios para cada eje
        posX = Random.Range(-1.0f, 1.0f);
        posY = Random.Range(0f, 1.0f);  // El límite inferior es 0 para que no se meta debajo del suelo
        posZ = Random.Range(-2.0f, 2.0f);

        //  Cambio la posición en cada uno de los ejes
        gameObject.transform.position += Vector3.left * posX;
        gameObject.transform.position += Vector3.up * posY;
        gameObject.transform.position += Vector3.forward * posZ;

        //  Defino los ángulos de giro aleatorios respecto de cada eje
        giroX = Random.Range(0.0f, 5.0f);
        giroY = Random.Range(5.0f, 15.0f);
        giroZ = Random.Range(0.0f, 3.0f);

    }

    // Update is called once per frame
    void Update()
    {
		// Añado Time.deltatime al factor de multiplicación de la velocidad
		// Así nos adaptamos a la velocidad del dispositivo
        float rotacion = Time.deltaTime * VelGiro;

        //  En cada frame: giro el cubo respecto a cada uno de los ejes
        gameObject.transform.Rotate(giroX * rotacion, giroY * rotacion, giroZ * rotacion);
        
    }
}
