﻿/************************************************/
/* Conmuta banda sonora                         */
/* Explicado en Cuadro 1. Punto 1.2)            */
/************************************************/

using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class BandaSonoraConmuta : MonoBehaviour
{
    private bool audioOn;  // Contiene el estado del reproductor de audio

    // Start is called before the first frame update
    void Start()
    {
        audioOn = true;   //  Por defecto, el reproductor está activado
        gameObject.GetComponent<AudioSource>().loop = true;  //  Activamos el loop de la banda sonora
    }

    // Update is called once per frame
    void Update()
    {
        if (Input.GetKeyDown(KeyCode.O))
        {
            audioOn = !audioOn;  //  Conmutamos el estado del reproductor
            ActivaSonido(audioOn);//  Llamamos a la función que enciende / apaga el reproductor
        }
    }

    //  Función que activa o desactiva el reproductor de audio
    //  Es pública, ya que se accede desde 'PremiosCaptura' para desactivarlo al capturar todos los premios
    public void ActivaSonido (bool estado)
    {
        if (estado == true)
        {
            gameObject.GetComponent<AudioSource>().Play(); // Activamos Banda sonora
        }
        else
        {
            gameObject.GetComponent<AudioSource>().Stop(); // Desctivamos Banda sonora
        }

        audioOn = estado; // Actualizamos el estado, por si se cambia el estado desde fuera del script
    }
}
