﻿/************************************************/
/* Opciones Cambia Escena                       */
/* Explicado en Cuadro 4. Punto 1.2)            */
/************************************************/

using System.Collections;
using System.Collections.Generic;
using UnityEngine;

using UnityEngine.SceneManagement;  //  Cargamos librería para gestión de escenas


public class OpcionesCambiaEscena : MonoBehaviour
{
    string nombreEscena;  //  Nombre de la escena a cambiar  
    int saltosDados, saltosNecesarios;  //  Controlador de saltos
    bool heContado;  // marca para ver si se ha contado el salto inicial

    // Start is called before the first frame update
    void Start()
    {
        heContado = false;
        saltosDados = 0;
    }

    // Update is called once per frame
    void Update() { } //  No la utilizamos para nada. Se puede borrar


    private void OnTriggerEnter(Collider loColisionado)
    {
        if(loColisionado.tag == "Player")
        {
            string nombreOpcion = gameObject.transform.parent.name; //  Leemos el nombre del cubo en el que estoy

            Debug.LogWarning(nombreOpcion);  //  Presentamos en el Debug el nombre del objeto "Padre" para comprobar

            //  Según la opción colisionada, se establece el nombre de la escena y los saltos a realizar
            if      (nombreOpcion == "Opcion 1")    { nombreEscena = "Inicio";   saltosNecesarios = 1; }  
            else if (nombreOpcion == "Opcion 2")    { nombreEscena = "Interior"; saltosNecesarios = 2; }
            else if (nombreOpcion == "Opcion 3")    { nombreEscena = "Exterior"; saltosNecesarios = 1; }

            if (!heContado)
            {  //  Si no hemos contado el salto
                saltosDados++; //  Incementamos el número de saltos realizados
                heContado = true; //  Marcamos que ya hemos contado el salto (hay que salir del collider para volver a contar)
            }

            if (saltosDados >= saltosNecesarios)
            {
                SceneManager.LoadScene(nombreEscena); //  Si ya hemos realizado los saltos correctos, cambiamos de escena
            }
        }
    }

    private void OnTriggerExit(Collider loColisionado)
    {
        if (loColisionado.tag == "Player")
        {
            heContado = false; //  Al salir del collider, marcamos para que, al volver a entrar, se cuente el salto de nuevo.
        }
        
    }

}       