﻿/************************************************/
/* General Cronometro                           */
/* Explicado en Cuadro 2. Punto 2.1)            */
/************************************************/

using System.Collections;
using System.Collections.Generic;
using UnityEngine;

using UnityEngine.UI;   //  Librería para gestión del UI

public class GeneralCronometro : MonoBehaviour
{
    float tiempo, tiempoAnt; //  Variables en las que almacenamos el tiempo transcurrido desde el inicio de la aplicación
    int minutos, segundos;  //  Variables numéricas con las que calcular minutos y segundos

    string sSegundos, sTiempo;  // Cadenas para ir formateando los minutos y segundos

    [SerializeField]
    private Text UICronometro;  //  Variable con el GemeObject Text del cronómetro

    // Start is called before the first frame update
    void Start()
    {
        tiempo = tiempoAnt = 0.0f;  //  Inicializamos variables  
        UICronometro.text = "0:00"; //  Ponemos mensaje inicial en el cronómetro
    }

    // Update is called once per frame
    void Update()
    {
        tiempo += Time.deltaTime;  //  Guardamos el tiempo transcurrido desde el inicio de la aplicación

        if (tiempo > tiempoAnt + 1) //  Comprobamos que ha pasado más de un segundo desde la úmtima vez que presentamos el cronómetro
        {
            tiempoAnt = tiempo; //  Guardamos el tiempo en el que presentamos el valor del cronómetro, para comparar después

            //  Calculamos minutos y segundos transcurridos
            minutos = (int)tiempo / 60;
            segundos = (int)tiempo % 60;

            sSegundos = "" + segundos; //  Creamos cadena con los segundos
            if (segundos < 10) sSegundos = "0" + sSegundos; //  Los segundos siempre tendrán dos dígitos

            sTiempo = minutos + ":" + sSegundos; //  Generamos cadena con el tiempo transcurrido
            
            // Debug.Log(sTiempo);  //  Presentamos cromómetro
            UICronometro.text = sTiempo;  //  Presentamos cromómetro

            if (tiempo >= 10)
            {
                UICronometro.color = Color.red;  //  Cambiamos el color del texto del cronómetro, una vez pasados los 10 segundos
            }


        }
    }
}
