﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class MovRigidBody : MonoBehaviour
{
    public float lecturaDesp;  // Lectura del desplazamiento

    public float velocidad = 1.5f;  //  Velocidad de desplazamiento en m/s
    public Vector3 desplazamiento;  //  Vector donde guardar el desplazamiento

    public float giro = 90;   //  Velocidad de giro, en grados / s
    public Vector3 rotacion;  //  Vector donde guardar el giro

    public Rigidbody rigidBody;  //  Variable donde almacenar el rigidbody del objeto

    // Start is called before the first frame update
    void Start()
    {   rigidBody = gameObject.GetComponent<Rigidbody>();  //  Inicializamos el rigidBody
    }

    // Update is called once per frame
    void FixedUpdate()
    {   lecturaDesp = Input.GetAxis("Vertical");  //  Leemos si pulsada la flecha arriba/abajo ó w/s ...
        float velY = rigidBody.velocity.y;        //  Guardamos la velocidad de "caida"

        desplazamiento = transform.forward * lecturaDesp * velocidad;  //  Calculamos el desplazamiento
        rigidBody.velocity = desplazamiento;        //  Cambiamos el valor de velocity (en el plano x,z)
        rigidBody.velocity = new Vector3(rigidBody.velocity.x, velY, rigidBody.velocity.z);  //  añadimos la velocidad en Y

        lecturaDesp = Input.GetAxis("Horizontal");  //  Leemos si pulsada la flecha izda/dcha ó a/d ...

        rotacion = Vector3.up * lecturaDesp * giro * Time.deltaTime;  //  Calculamos el giro
        transform.Rotate(rotacion);     //  Llamamos al método, indicando el giro
    }
}



/*
    public float inclina = 45;
        rotacionx = Vector3.forward * lecturaDesp * inclina * Time.deltaTime;
        float cosa = lecturaDesp * inclina * Time.deltaTime;
        transform.eulerAngles = new Vector3 (transform.rotation.x, transform.rotation.y, cosa);

*/
