﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Explota : MonoBehaviour
{
    public Transform explosionPrefab;  //  Prefab con las partículas de la explosión

    // Start is called before the first frame update
    void Start() {  }

    // Update is called once per frame
    void Update() { }


    void OnCollisionEnter(Collision collision)
    {
        string etiqueta = collision.collider.tag;  //  Leemos la etiqueta del objeto con el que hemos colisionado

        if (etiqueta == "proyectil")  // Solo actúa si hemos colisionado con un proyectil 
        {
            ContactPoint contact = collision.contacts[0];  //  Guardamos el primer punto de colisión guardado
            Quaternion rotation = Quaternion.FromToRotation(Vector3.up, contact.normal); // Calculamos ángulo donde colisión
            Vector3 position = contact.point;   //  Guardamos el punto de la colisión
            Instantiate(explosionPrefab, position, rotation);  //  instanciamos un gameObject de partículas en el punto de colisión
            Destroy(gameObject);  //  Destuimos el objeto en el que estamos
        }
    }
}




