﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class MovCharacterCon : MonoBehaviour
{
    public float lecturaDesp;  // Lectura del desplazamiento

    public float velocidad = 1.5f;  //  Velocidad de desplazamiento en m/s
    public Vector3 desplazamiento;  //  Vector donde guardar el desplazamiento

    public float giro = 90;   //  Velocidad de giro, en grados / s
    public Vector3 rotacion;  //  Vector donde guardar el giro

    public CharacterController characterController;   //  Variable donde almacenar el characterController del objeto

    // Start is called before the first frame update
    void Start()
    {   characterController = gameObject.GetComponent<CharacterController>();   //  Inicializamos el characterController
    }

    // Update is called once per frame
    void Update()
    {   lecturaDesp = Input.GetAxis("Vertical");  //  Leemos si pulsada la flecha arriba/abajo ó w/s ...

        desplazamiento = transform.forward * lecturaDesp * velocidad * Time.deltaTime;  //  Calculamos el desplazamiento
        characterController.Move(desplazamiento);   //  Llamamos al método, indicando el desplazamiento

        lecturaDesp = Input.GetAxis("Horizontal");  //  Leemos si pulsada la flecha izda/dcha ó a/d ...

        rotacion = Vector3.up * lecturaDesp * giro * Time.deltaTime;  //  Calculamos el giro
        transform.Rotate(rotacion);     //  Llamamos al método, indicando el giro
    }
}


