﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Dispara : MonoBehaviour
{
    private float velocidad = 50f;  //  Velocidad a la que sale la esfera

    GameObject disparo;  //  GameObject que vamos creando por cada disparo

    public GameObject Bala;     //  Prefab con la bala que hemos creado
    public GameObject posSal;  //  GameObject situado en el personaje para indicar la posición de disparo

    bool apretado = false;  //  booleano para evitar los disparos repetidos

    // Start is called before the first frame update
    void Start()  {  }

    // Como tratamos RigidBody, usamos FixedUpdate
    void FixedUpdate()
    {
        if (Input.GetKeyDown(KeyCode.LeftAlt) && !apretado)
        {
            disparo = Instantiate (Bala, posSal.transform.position, posSal.transform.rotation); //  Instanciamos bala en la posición inicial
            disparo.GetComponent<Rigidbody>().velocity = transform.forward * velocidad; //  Aplicamos la velocidad a la bala
            Destroy(disparo.gameObject, 3); //  Eliminamos la bala a los 3 segundos de haberla disparado

            apretado = true;    //  Marcamos tecla apredada
        }

        if (!Input.anyKeyDown) apretado = false;  //  Marcamos tecla suelta
    }
}


