﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class MovTransform : MonoBehaviour
{
    public float lecturaDesp;  // Lectura del desplazamiento

    public float velocidad = 1.5f;  //  Velocidad de desplazamiento en m/s
    public Vector3 desplazamiento;  //  Vector donde guardar el desplazamiento

    // Start is called before the first frame update
    void Start() { }

    // Update is called once per frame
    void Update()
    {
        lecturaDesp = Input.GetAxis("Vertical");  //  Leemos si pulsada la flecha arriba/abajo ó w/s ...

        desplazamiento = Vector3.forward * lecturaDesp * velocidad * Time.deltaTime;  //  Calculamos el desplazamiento
        transform.position = transform.position + desplazamiento;                     //  Cambiamos el valor de transform


        lecturaDesp = Input.GetAxis("Horizontal");  //  Leemos si pulsada la flecha izda/dcha ó a/d ...

        desplazamiento = Vector3.right * lecturaDesp * velocidad * Time.deltaTime;    //  Calculamos el desplazamiento  
        transform.position = transform.position + desplazamiento;                     //  Cambiamos el valor de transform

    }
}

/*
    public float giro = 90;
    public Vector3 rotacion;

        rotacion = Vector3.up * lecturaDesp * giro * Time.deltaTime;
        transform.Rotate(rotacion);
*/
